<?php

namespace Omnipay\Aifo\Message;

use Omnipay\Common\Message\AbstractRequest as OmnipayAbstractRequest;
use Omnipay\Aifo\Traits\Parametrable;

abstract class AbstractRequest extends OmnipayAbstractRequest
{
    use Parametrable;

    protected function createSignature(string $shopId, float $amount, string $key, string $invoiceId, int $signatureType): string
    {
        $signString = $shopId . ':' . $amount . ':' . $key . ':' . $invoiceId;
        
        switch ($signatureType) {
            case 1: 
                return hash('md5', $signString);
            case 2: 
                return hash('sha256', $signString);
            case 3: 
                return hash('sha1', $signString);
            case 4: 
                return hash('ripemd160', $signString);
            case 5: 
                return hash('sha384', $signString);
            case 6: 
                return hash('sha512', $signString);
            default:
                return hash('sha256', $signString); 
        }
    }
}
