<?php

namespace Omnipay\Aifo\Message;

use Omnipay\Common\Message\AbstractResponse;
use Omnipay\Common\Message\RedirectResponseInterface;

class PurchaseResponse extends AbstractResponse implements RedirectResponseInterface
{
    protected string $endpoint = 'https://aifo.pro/pay/';

    public function isSuccessful(): bool
    {
        return false; 
    }

    public function isRedirect(): bool
    {
        return true; 
    }

    public function getRedirectUrl(): string
    {
        $shopId = (string)($this->data['shop_id'] ?? '');
        $payId = urlencode((string)($this->data['pay_id'] ?? ''));
        $amount = (float)($this->data['amount'] ?? 0);
        $sign = (string)($this->data['sign'] ?? '');
        
        $redirectUrl = $this->endpoint . "?shop_id=" . $shopId . "&pay_id=" . $payId . "&amount=" . $amount . "&sign=" . $sign;
        
        if (!empty($this->data['desc'])) {
            $desc = urlencode((string)$this->data['desc']);
            $redirectUrl .= "&desc={$desc}";
        }
        
        return $redirectUrl;
    }

    public function getRedirectMethod(): string
    {
        return 'GET';
    }

    public function getRedirectData(): ?array
    {
        return null;
    }
}
