<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Тип, описывающий делегированный доступ к счету.
	 * Specifies delegated access to a MONETA.RU account.
	 * 
 */
class AccountRelation
{
	
	/**
	 * Номер счета в системе МОНЕТА.РУ.
	 * MONETA.RU account number.
	 * 
	 *
	 * @var long
	 */
	 public $accountId = null;

	/**
	 * Email пользователя, которому предоставляется делегированный доступ к счету.
	 * Email of the user who has delegated access to the specified account.
	 * 
	 *
	 * @var string
	 */
	 public $principalEmail = null;

	/**
	 * Просмотр счета.
	 * Indicates whether the specified user can view the account information. Valid valus are:
	 * true. The specified user can view the account information.
	 * false. The specified user cannot view the account information.
	 * 
	 *
	 * @var boolean
	 */
	 public $canViewAccount = null;

	/**
	 * Редактирование счета.
	 * Indicates whether the specified user can change the account settings. Valid values are:
	 * true. The specified user can change the account settings.
	 * false. The specified user cannot change the account settings.
	 * 
	 *
	 * @var boolean
	 */
	 public $canEditAccount = null;

	/**
	 * Проведение операций.
	 * Indicates whether the specified user can process transactions. Valid values are:
	 * true. The specified user can process transactions.
	 * false. The specified user cannot process transactions.
	 * 
	 *
	 * @var boolean
	 */
	 public $canProcessOperation = null;

}
