<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Банковские реквизиты в системе МОНЕТА.РУ. Данные представляются в виде "ключ-значение".
	 * Возможные ключи:
	 * is_international. Международные банковские реквизиты (true/false).
	 * bank. Банк.
	 * bik. БИК.
	 * account. Расчетный счет.
	 * corr_bank. Корреспондентский банк.
	 * corr_account. Корреспондентский счет.
	 * country. Страна.
	 * state. Регион/республика.
	 * city. Город.
	 * kbk. КБК.
	 * oktmo. Общероссийский классификатор территорий муниципальных образований.
	 * kpp. КПП.
	 * username. Наименование получателя.
	 * Bank account details. The information is returned as a list of key-value pairs.
	 * Valid keys are:
	 * is_international. Indicates whether the bank uses international account details. Valid values are:
	 * true. International bank account details.
	 * false. Russian bank account details.
	 * bank. Bank name.
	 * bik. SWIFT/BIC number.
	 * account. IBAN/settlement account.
	 * corr_bank. Correspondent bank.
	 * corr_account. Correspondent account.
	 * country. Country.
	 * state. Region/state.
	 * city. City.
	 * kbk. Budget classification code.
	 * oktmo. Russian Classifier of Municipal Unit Territories.
	 * kpp. Code of reason for tax registration.
	 * username. Payee's name.
	 * 
 */
class BankAccount
{
	
	/**
	 * ID банковских реквизитов.
	 * Bank account ID.
	 * 
	 *
	 * @var long
	 */
	 public $id = null;

	/**
	 * 
	 *
	 * @var KeyValueAttribute
	 */
	 public $attribute = null;

	/**
	 * 
	 *
	 * @param KeyValueAttribute
	 *
	 * @return void
	 */
	public function addAttribute(KeyValueAttribute $item)
	{
		$this->attribute[] = $item;
	}

}
