<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Запрос на редактирование счета.
	 * У счета можно изменить свойства "псевдоним" и "платежный пароль".
	 * Account modification request.
	 * It's allowed to change alias and payment password for account.
	 * 
 */
class EditAccountRequest
{
	
	/**
	 * Идентификатор редактируемого счета.
	 * The unique identifier of the account that you want to edit.
	 * 
	 *
	 * @var long
	 */
	 public $id = null;

	/**
	 * Новый псевдоним счета.
	 * Псевдоним счета должен быть уникальным среди счетов пользователя.
	 * New alias of account.
	 * Account alias. Specify a unique name among the other accounts of the specified user.
	 * 
	 *
	 * @var string
	 */
	 public $alias = null;

	/**
	 * Новый платежный пароль.
	 * Для того чтобы изменить платежный пароль, необходимо указать предыдущий платежный пароль.
	 * New payment password for the account.
	 * You must specify the oldPaymentPassword element to specify a new payment password.
	 * 
	 *
	 * @var string
	 */
	 public $paymentPassword = null;

	/**
	 * Текущий платежный пароль.
	 * Для того чтобы изменить платежный пароль на новый, необходимо указать текущий платежный пароль.
	 * Current payment password.
	 * This element is required only if the request includes the PaymentPassword element.
	 * 
	 *
	 * @var string
	 */
	 public $oldPaymentPassword = null;

	/**
	 * URL после списания средств.
	 * Specifies the URL of the script that MONETA.RU calls after debiting the funds from the account.
	 * 
	 *
	 * @var string
	 */
	 public $onSuccessfulDebitUrl = null;

	/**
	 * URL после зачисления средств.
	 * Specifies the URL of the script that MONETA.RU calls after crediting funds to the account.
	 * 
	 *
	 * @var string
	 */
	 public $onSuccessfulCreditUrl = null;

	/**
	 * Код проверки целостности данных.
	 * Signature that MONETA.RU uses to verify data integrity submitted from a payment form.
	 * 
	 *
	 * @var string
	 */
	 public $signature = null;

	/**
	 * Если баланс счета меньше данного значения, то раз в сутки уходит уведомление об этом событии.
	 * Specifies the minimum balance threshold for an account. If the balance drops below the threshold, MONETA.RU sends daily notifications to the account owner.
	 * 
	 *
	 * @var decimal
	 */
	 public $lowBalanceThreshold = null;

	/**
	 * Если баланс счета больше данного значения, то раз в сутки уходит уведомление об этом событии.
	 * Specifies the maximum balance threshold for an account. If the balance exceeds the threshold, MONETA.RU sends daily notifications to the account owner.
	 * 
	 *
	 * @var decimal
	 */
	 public $highBalanceThreshold = null;

	/**
	 * Счет-прототип с которого берутся свойства "по умолчанию".
	 * Prototype account number. Settings from this account are used as default values.
	 * 
	 *
	 * @var long
	 */
	 public $prototypeAccountId = null;

	/**
	 * Запрос для платежного пароля.
	 * Challenge passcode that you received in the GetAccountPaymentPasswordChallenge response
	 * in the paymentPasswordChallenge element. Specify this element in the following cases:
	 * If a user gets payment passwords by SMS, set paymentPasswordChallenge to SMS. Set paymentPassword to the value that the user receives in the SMS from MONETA.RU.
	 * If a user gets a sequence number (index) for a password from a list of transaction authentication numbers (TANs), set paymentPasswordChallenge to the TAN index. Set paymentPassword to the TAN that has the specified index.
	 * 
	 *
	 * @var string
	 */
	 public $oldPaymentPasswordChallenge = null;

	/**
	 * URL после отмены списания средств.
	 * Specifies the URL of the script that MONETA.RU calls if a debit transaction is canceled.
	 * 
	 *
	 * @var string
	 */
	 public $onCancelledDebitUrl = null;

	/**
	 * URL после отмены зачисления средств.
	 * Specifies the URL of the script that MONETA.RU calls if a deposit transaction is canceled.
	 * 
	 *
	 * @var string
	 */
	 public $onCancelledCreditUrl = null;

}
