<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Запрос на получение списка счетов по заданным условиям поиска.
	 * Request for a list of accounts that match the specified search criteria.
	 * 
 */
class FindAccountsListRequest extends Entity
{
	
	/**
	 * Пользователь, которому принадлежат счета. Если это поле не задано, то используется текущий пользователь.
	 * The owner of the accounts. If you omit this element, the request uses the name of the user who sends the request.
	 * 
	 *
	 * @var long
	 */
	 public $unitId = null;

	/**
	 * Название счета. Поиск происходит по прямому совпадению.
	 * Для задания маски можно указать спец-символы "*" или "?".
	 * Account alias. An alias can include the following wildcards: asterisk (*) and question mark (?).
	 * 
	 *
	 * @var string
	 */
	 public $alias = null;

	/**
	 * Валюта счета.
	 * The currency of the account.
	 * 
	 *
	 * @var string
	 */
	 public $currency = null;

	/**
	 * Является ли счет делегированным.
	 * Поле не указано - выбрать все счета.
	 * false. Выбрать только неделегированные счета.
	 * true. Выбрать только делегированные счета.
	 * Indicates whether the account is delegated. Valid values are:
	 * true. Select only delegated accounts.
	 * false. Select only non-delegated (owned) accounts.
	 * Omit this element to select both delegated and non-delegated accounts.
	 * 
	 *
	 * @var boolean
	 */
	 public $isDelegatedAccount = null;

}
