<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Запрос на получение отчетов по ID пользователя. Если данные не найдены, возвращается пустой список.
	 * Request for reports by a user ID. MONETA.RU returns an empty list if it cannot find reports.
	 * 
 */
class FindReportsRequest
{
	
	/**
	 * ID пользователя в системе МОНЕТА.РУ. Если это поле не задано, то используется текущий пользователь.
	 * User ID. If you omit this element, MONETA.RU uses the ID of the user who sends the request.
	 * 
	 *
	 * @var long
	 */
	 public $unitId = null;

	/**
	 * ID отчета.
	 * Если в запросе указан ID отчета, то в ответе (FindReportsResponse) в списке отчетов (элемент report) будет один отчет.
	 * Report ID.
	 * 
	 *
	 * @var long
	 */
	 public $reportId = null;

	/**
	 * Год, за который следует искать экземпляры отчета.
	 * Если в запросе это поле не будет указано,
	 * то в ответе (FindReportsResponse) будут возвращены только отчеты, а экземпляры отчетов возвращены не будут.
	 * То есть, если в запросе не указать элемент year, то в ответе элемент reportInstance (список экземпляров отчета)
	 * для типа Report будет пустым.
	 * Report instances year.
	 * 
	 *
	 * @var int
	 */
	 public $year = null;

}
