<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Тип, описывающий параметры операции в запросах.
	 * Transaction parameters for SOAP requests.
	 * 
 */
class TransactionRequestType extends Entity
{
	
	/**
	 * Номер счета плательщика.
	 * Account number of the payer.
	 * 
	 *
	 * @var string
	 */
	 public $payer = null;

	/**
	 * Номер счета получателя.
	 * Account number of the payee.
	 * 
	 *
	 * @var string
	 */
	 public $payee = null;

	/**
	 * Сумма операции.
	 * Если флаг isPayerAmount отсутствует
	 * и пользователь имеет доступ только к счету плательщика,
	 * то интерпретируется как сумма к списанию (в валюте плательщика).
	 * Если флаг isPayerAmount отсутствует
	 * и пользователь имеет доступ только к счету получателя,
	 * то интерпретируется как сумма к зачислению (в валюте получателя).
	 * Всегда используйте элемент isPayerAmount, чтобы избежать ошибки по интерпретации суммы.
	 * Transaction amount. The currency of the transaction is specified by the isPayerAmount
	 * element. If a request does not include the isPayerAmount element, MONETA.RU uses the
	 * following rules to determine the currency of the transaction:
	 * If a user has access only to the payer's account, MONETA.RU uses the currency of
	 * the payer's account for the transaction.
	 * If a user has access only to the payee's account, MONETA.RU uses the currency of
	 * the payee's account for the transaction.
	 * Always use the isPayerAmount element to avoid ambiguity.
	 * 
	 *
	 * @var decimal
	 */
	 public $amount = null;

	/**
	 * Если пользователь имеет доступ как к счету плательщика, так и счету получателя,
	 * то флаг isPayerAmount обязателен.
	 * Если флаг isPayerAmount установлен (true), то amount используется как
	 * сумма к списанию (в валюте плательщика).
	 * Если флаг isPayerAmount сброшен (false), то amount используется как сумма
	 * к зачислению (в валюте получателя).
	 * This element is required if a user has access to the payer's and to the payee's
	 * accounts.
	 * Valid values:
	 * true. MONETA.RU uses the currency of the payer's account for the
	 * transaction amount.
	 * false. MONETA.RU uses the currency of the payee's account for the
	 * transaction amount.
	 * 
	 *
	 * @var boolean
	 */
	 public $isPayerAmount = null;

	/**
	 * Платежный пароль счета плательщика.
	 * Payment password for the payer's MONETA.RU account.
	 * 
	 *
	 * @var normalizedString
	 */
	 public $paymentPassword = null;

	/**
	 * Внешний номер операции.
	 * Merchant transaction ID.
	 * 
	 *
	 * @var string
	 */
	 public $clientTransaction = null;

	/**
	 * Описание операции.
	 * Transaction description or comments.
	 * 
	 *
	 * @var normalizedString
	 */
	 public $description = null;

	/**
	 * Набор полей, которые необходимо сохранить в качестве
	 * атрибутов операции. Значения дат в формате dd.MM.yyyy HH:mm:ss
	 * Key-value pairs that will be saved as transaction
	 * attributes. For dates, use the following format: dd.MM.yyyy HH:mm:ss
	 * 
	 *
	 * @var OperationInfo
	 */
	 public $operationInfo = null;

	/**
	 * Запрос для платежного пароля.
	 * Challenge passcode that you received in the GetAccountPaymentPasswordChallenge
	 * response in the paymentPasswordChallenge element. Specify this element in the
	 * following cases:
	 * If a user gets payment passwords by SMS, set paymentPasswordChallenge to SMS.
	 * Set paymentPassword to the value that the user receives in the SMS from
	 * MONETA.RU.
	 * If a user gets a sequence number (index) for a password from a list of
	 * transaction authentication numbers (TANs), set paymentPasswordChallenge to the
	 * TAN index. Set paymentPassword to the TAN that has the specified index.
	 * 
	 *
	 * @var string
	 */
	 public $paymentPasswordChallenge = null;

	/**
	 * Персональные данные пользователя.
	 * Personal information about the user.
	 * 
	 *
	 * @var PersonalInformation
	 */
	 public $personalInformation = null;

}
