<?php

class OurSourceQuery extends SourceQuery {

	private $server = null;

	public function setServer($server) {
		$this->server = $server;

		return $this;
	}

	public function isServerCanWorkWithRcon() {
		if(
			empty($this->server->id)
			|| $this->server->rcon == 2
			|| empty($this->server->rcon_password)
		) {
			return false;
		} else {
			return true;
		}
	}

	public function checkConnect() {
		if($this->server->game == 'Counter-Strike: 1.6') {
			$this->Connect($this->server->ip, $this->server->port, 1, SourceQuery::GOLDSOURCE);
		} else {
			$this->Connect($this->server->ip, $this->server->port, 1, SourceQuery::SOURCE);
		}

		return $this;
	}

	public function auth() {
		$this->SetRconPassword($this->server->rcon_password);

		return $this;
	}

	public function send($command) {
		$answer = $this->Rcon($command);
		$this->log($command);

		return $answer;
	}

	public function reloadAdmins($server = null) {
		if(is_null($this->server)) {
			$this->setServer(
				(new ServersManager())->getServer($server)
			);
		}

		if(!$this->isServerCanWorkWithRcon()) {
			return false;
		}

		$this->checkConnect();
		$this->auth();

		$command = (new ServerCommands())
			->getCommandBySlug(
				ServerCommands::RELOAD_ADMINS_COMMAND_SLUG,
				$this->server->id
			);

		$command = empty($command->command) ? '' : $command->command;

		$answer = $this->send($command);
		$this->Disconnect();

		return $answer;
	}

	public function log($command)
	{
		$user = defineLogInitiator('Админ Центр');

		writeLineToLog("rcon_log_" . $this->server->id, "[" . date("Y-m-d H:i:s") . " | Пользователь: " . $user . "] : [Команда: " . clean($command) . "]");
	}
}