<?php
if(!isDevMode()){
	show_error_page('not_allowed');
}

global $PI;

$configSecondary = pdo()
	->query("SELECT payments_debug, version FROM config__secondary LIMIT 1")
	->fetch(PDO::FETCH_OBJ);


$logs = (new Logs())->getLogs();

(new Page())
	->setBreadCrumbs(
		[
			$PI->to_nav('admin'),
			$PI->to_nav('admin_diagnostics', 1)
		]
	)
	->collectPage('diagnostics.tpl', [
		'phpversion' => phpversion(),
		'paymentsDebug' => $configSecondary->payments_debug,
		'version' => $configSecondary->version
	]);
