<?php

global $messages;
global $PI;

$Pm = new Payments;

$configSecondary = pdo()
	->query("SELECT payments_debug FROM config__secondary LIMIT 1")
	->fetch(PDO::FETCH_OBJ);

if($configSecondary->payments_debug == 1 && isDevMode()) {
	writeLineToLog(
		'payment_debug_log',
		json_encode(
			[
				'date' => date("Y-m-d H:i:s"),
				'ip'   => get_ip(),
				'info' => [
					'POST'        => $_POST,
					'GET'         => $_GET,
					'SERVER'      => $_SERVER,
					'php://input' => file_get_contents('php://input')
				]
			]
		)
	);
}

$merchantsSettings = pdo()
	->query("SELECT * FROM config__bank LIMIT 1")
	->fetch(PDO::FETCH_OBJ);

if(isset($_GET['result_qw']) && $_GET['result_qw'] == 'get') {
	$payMethod = 'qw';
	$currentCurrency = Payments::getCashierCurrency($payMethod);

	$data = json_decode(file_get_contents('php://input'), true);
	if(array_key_exists('HTTP_X_API_SIGNATURE_SHA256', $_SERVER)) {
		$signature = $_SERVER['HTTP_X_API_SIGNATURE_SHA256'];
	} else {
		$signature = null;
	}

	if(empty($data) || empty($signature)) {
		$Pm->paymentLog($payMethod, "empty data", pdo(), 0, 2);
		http_response_code(400);
		exit('Error: [empty data]');
	}

	$status    = $data['bill']['status']['value'];
	$amount    = clean($data['bill']['amount']['value'], 'float');
	$currency  = clean($data['bill']['amount']['currency']);
	$payNumber = clean($data['bill']['billId'], 'int');
	$userId    = clean($data['bill']['customer']['account'], 'int');

	if($currentCurrency != $currency) {
		$Pm->paymentLog($payMethod, "invalid currency", pdo(), 0, 2);
		http_response_code(400);
		exit('Error: [invalid currency]');
	}

	$Qiwi = new Qiwi($merchantsSettings->qw_pass);

	if(!$Qiwi->checkNotificationSignature(
			$signature,
			$data,
			$merchantsSettings->qw_pass
		) && $status == 'PAID') {
		$Pm->paymentLog($payMethod, "bad sign", pdo(), $userId, 2);
		http_response_code(400);
		exit("Error: [bad signature]");
	} else {
		$userInfo = $Pm->getUser(pdo(), $userId);
		if(empty($userInfo->id)) {
			$Pm->paymentLog($payMethod, "unknown user", pdo(), $userId, 2);
			http_response_code(404);
			exit('Error: [User does not exist]');
		} else {
			if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
				exit('OK');
			}

			$Pm->doPayAction(
				pdo(),
				$userInfo,
				$amount,
				configs()->bank,
				$payMethod,
				$payNumber,
				$messages['RUB']
			);
			exit('OK');
		}
	}
}


if(isset($_GET['qiwi_new']) && $_GET['qiwi_new'] == 'pay') {
	$payMethod = 'qw_new';
	$currentCurrency = Payments::getCashierCurrency($payMethod, '643');

	$data = json_decode(file_get_contents('php://input'), true);

	if(empty($data)) {
		$Pm->paymentLog($payMethod, "empty data", pdo(), 0, 2);
		http_response_code(400);
		exit('Error: [empty data]');
	}

	$status    = clean($data['payment']['status']);
	$amount    = clean($data['payment']['sum']['amount'], 'float');
	$currency  = clean($data['payment']['sum']['currency']);
	$type      = clean($data['payment']['type']);
	$payNumber = clean($data['payment']['txnId']);

	if(!empty($data['payment']['comment'])) {
		$commentParts = explode('#', $data['payment']['comment']);

		if(!empty($commentParts[1])) {
			$code = $commentParts[1];

			if(base64_encode(base64_decode($code, true)) === $code) {
				$codeParts = explode(':', base64_decode($code, true));

				global $host;

				if($codeParts[0] == $host) {
					$userId = clean((($codeParts[1] / 13) + 1543) / 10000, 'int');
				}
			}
		}
	}

	if(empty($userId)) {
		http_response_code(400);
		exit('Error: [empty user id]');
	}

	$signature = hash_hmac(
		"sha256",
		$data['payment']['sum']['currency']
		. '|' . $data['payment']['sum']['amount']
		. '|' . $data['payment']['type']
		. '|' . $data['payment']['account']
		. '|' . $data['payment']['txnId'],
		base64_decode($merchantsSettings->qw_new_sign_key)
	);

	if ($status != 'SUCCESS') {
		$Pm->paymentLog($payMethod, "invalid status", pdo(), $userId, 2);
		http_response_code(400);
		exit("Error: [invalid status]");
	}

	if($type != 'IN') {
		$Pm->paymentLog($payMethod, "invalid status", pdo(), $userId, 2);
		http_response_code(400);
		exit("Error: [invalid type]");
	}

	if($currentCurrency != $currency) {
		$Pm->paymentLog($payMethod, "invalid currency", pdo(), $userId, 2);
		http_response_code(400);
		exit('Error: [invalid currency]');
	}

	if (!hash_equals($signature, $data['hash'])) {
		$Pm->paymentLog($payMethod, "bad sign", pdo(), $userId, 2);
		http_response_code(400);
		exit("Error: [bad signature]");
	} else {
		$userInfo = $Pm->getUser(pdo(), $userId);
		if(empty($userInfo->id)) {
			$Pm->paymentLog($payMethod, "unknown user", pdo(), $userId, 2);
			http_response_code(404);
			exit('Error: [User does not exist]');
		} else {
			if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
				exit('OK');
			}

			$Pm->doPayAction(
				pdo(),
				$userInfo,
				$amount,
				configs()->bank,
				$payMethod,
				$payNumber,
				$messages['RUB']
			);
			exit('OK');
		}
	}
}

if(isset($_GET['result_ya']) && $_GET['result_ya'] == 'get') {
	$payMethod = 'ya';

	if(empty($_POST["amount"]) || empty($_POST["operation_id"]) || empty($_POST["label"]) || empty($_POST["sha1_hash"]) || empty($_POST["unaccepted"])) {
		$Pm->paymentLog($payMethod, "empty data", pdo(), 0, 2);
		exit('Error: [empty data]');
	}

	$amount    = clean($_POST['withdraw_amount'], 'float');
	$payNumber = clean($_POST["label"], 'int');
	$userId    = (int)clean(substr($payNumber, 0, 7), 'int');

	if(
		sha1(
			$_POST['notification_type']
			. '&' . $_POST['operation_id']
			. '&' . $_POST['amount']
			. '&' . $_POST['currency']
			. '&' . $_POST['datetime']
			. '&' . $_POST['sender']
			. '&' . $_POST['codepro']
			. '&' . $merchantsSettings->ya_key
			. '&' . $_POST["label"]
		) != $_POST['sha1_hash']
	) {
		$Pm->paymentLog($payMethod, "bad sign", pdo(), $payNumber, 2);
		exit("bad sign\n");
	} else {
		$userInfo = $Pm->getUser(pdo(), $userId);
		if(empty($userInfo->id)) {
			$Pm->paymentLog($payMethod, "unknown user", pdo(), $userId, 2);
			exit('Error: [User does not exist]');
		} else {
			if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
				exit('OK');
			}

			$Pm->doPayAction(
				pdo(),
				$userInfo,
				$amount,
				configs()->bank,
				$payMethod,
				$payNumber,
				$messages['RUB']
			);
			exit('OK');
		}
	}
}

if(isset($_GET['result_wo']) && $_GET['result_wo'] == 'get') {
	$payMethod = 'wo';

	$userId = clean($_POST['user_id'], 'int');

	if(!isset($_POST["WMI_SIGNATURE"])) {
		$Pm->paymentLog($payMethod, "invalid request", pdo(), $userId, 2);
		exit('WMI_RESULT=RETRY&WMI_DESCRIPTION=Empty WMI_SIGNATURE');
	}
	if(!isset($_POST["WMI_PAYMENT_NO"])) {
		$Pm->paymentLog($payMethod, "invalid request", pdo(), $userId, 2);
		exit('WMI_RESULT=RETRY&WMI_DESCRIPTION=Empty WMI_PAYMENT_NO');
	}
	if(!isset($_POST["WMI_ORDER_STATE"])) {
		$Pm->paymentLog($payMethod, "invalid request", pdo(), $userId, 2);
		exit('WMI_RESULT=RETRY&WMI_DESCRIPTION=Empty WMI_ORDER_STATE');
	}

	$amount    = clean($_POST['WMI_PAYMENT_AMOUNT'], 'float');
	$payNumber = clean($_POST['WMI_PAYMENT_NO'], 'int');
	foreach($_POST as $name => $value) {
		if($name !== "WMI_SIGNATURE") {
			$params[$name] = $value;
		}
	}

	uksort($params, "strcasecmp");
	$values = "";
	foreach($params as $name => $value) {
		$values .= $value;
	}
	if(base64_encode(
			pack("H*", md5($values . $merchantsSettings->wo_pass))
		) != $_POST["WMI_SIGNATURE"]) {
		$Pm->paymentLog($payMethod, "bad sign", pdo(), $userId, 2);
		exit('WMI_RESULT=RETRY&WMI_DESCRIPTION=bad sign');
	} else {
		if(strtoupper($_POST["WMI_ORDER_STATE"]) == "ACCEPTED") {
			$userInfo = $Pm->getUser(pdo(), $userId);
			if(empty($userInfo->id)) {
				$Pm->paymentLog($payMethod, "unknown user", pdo(), $userId, 2);
				exit('WMI_RESULT=RETRY&WMI_DESCRIPTION=User does not exist');
			} else {
				if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
					exit("WMI_RESULT=OK");
				}

				$Pm->doPayAction(
					pdo(),
					$userInfo,
					$amount,
					configs()->bank,
					$payMethod,
					$payNumber,
					$messages['RUB']
				);
			}
			exit("WMI_RESULT=OK");
		} else {
			$Pm->paymentLog($payMethod, "invalid request", pdo(), $userId, 2);
			exit('WMI_RESULT=RETRY&WMI_DESCRIPTION=bad sign');
		}
	}
}

if(isset($_GET['result_ik']) && $_GET['result_ik'] == 'get') {
	$payMethod       = 'ik';
	$currentCurrency = Payments::getCashierCurrency($payMethod);

	try {
		if(
			empty($_POST['ik_sign'])
			|| empty($_POST['ik_am'])
			|| empty($_POST['ik_x_id'])
			|| empty($_POST['ik_pm_no'])
			|| empty($_POST['ik_cur'])
			|| empty($_POST['ik_inv_st'])
		) {
			throw new Exception('empty data');
		}

		$amount    = clean($_POST['ik_am'], 'float');
		$payNumber = clean($_POST['ik_pm_no'], 'int');
		$userId    = clean($_POST['ik_x_id'], 'int');

		$sign = $_POST['ik_sign'];
		unset($_POST['ik_sign']);

		ksort($_POST, SORT_STRING);
		array_push($_POST, $merchantsSettings->ik_pass1);
		$currentSign = implode(':', $_POST);
		$currentSign = base64_encode(md5($currentSign, true));

		if($sign != $currentSign) {
			throw new Exception('bad sign');
		}

		if($_POST['ik_inv_st'] != 'success') {
			exit();
		}

		if($currentCurrency != $_POST['ik_cur']) {
			throw new Exception('invalid request');
		}

		$userInfo = $Pm->getUser(pdo(), $userId);
		if(empty($userInfo->id)) {
			throw new Exception('unknown user');
		} else {
			if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
				exit('OK');
			}

			$Pm->doPayAction(
				pdo(),
				$userInfo,
				$amount,
				configs()->bank,
				$payMethod,
				$payNumber,
				$messages['RUB']
			);
			exit('OK');
		}
	} catch(Exception $e) {
		if(empty($userId)) {
			$userId = 0;
		}

		$Pm->paymentLog($payMethod, $e->getMessage(), pdo(), $userId, 2);
		http_response_code(500);
		exit($e->getMessage());
	}
}

if(isset($_GET['result']) && $_GET['result'] == 'get') {
	$payMethod = 'fk';

	$amount    = clean($_POST['AMOUNT'], 'float');
	$payNumber = clean($_POST['MERCHANT_ORDER_ID'], 'int');
	$userId    = clean($_POST['us_user'], 'int');

	$sign = md5(
		$merchantsSettings->fk_login . ':' . $_POST['AMOUNT'] . ':' . $merchantsSettings->fk_pass2 . ':' . $_POST['MERCHANT_ORDER_ID']
	);

	if($sign != $_POST['SIGN']) {
		$Pm->paymentLog($payMethod, "bad sign", pdo(), $userId, 2);
		exit("bad sign");
	}

	$userInfo = $Pm->getUser(pdo(), $userId);
	if(empty($userInfo->id)) {
		$Pm->paymentLog($payMethod, "unknown user", pdo(), $userId, 2);
		exit('Error: [User does not exist]');
	} else {
		if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
			exit('YES');
		}

		$Pm->doPayAction(
			pdo(),
			$userInfo,
			$amount,
			configs()->bank,
			$payMethod,
			$payNumber,
			$messages['RUB']
		);
		exit('YES');
	}
}

if(isset($_GET['result_fk']) && $_GET['result_fk'] == 'get') {
	$payMethod = 'fk_new';

	$amount    = clean($_POST['AMOUNT'], 'float');
	$payNumber = clean($_POST['MERCHANT_ORDER_ID'], 'int');
	$userId    = clean($_POST['us_user'], 'int');

	$sign = md5(
		$merchantsSettings->fk_new_login . ':' . $_POST['AMOUNT'] . ':' . htmlspecialchars_decode(
			$merchantsSettings->fk_new_pass2
		) . ':' . $_POST['MERCHANT_ORDER_ID']
	);

	if($sign != $_POST['SIGN']) {
		$Pm->paymentLog($payMethod, "bad sign", pdo(), $userId, 2);
		exit("bad sign");
	}

	$userInfo = $Pm->getUser(pdo(), $userId);
	if(empty($userInfo->id)) {
		$Pm->paymentLog($payMethod, "unknown user", pdo(), $userId, 2);
		exit('Error: [User does not exist]');
	} else {
		if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
			exit('YES');
		}

		$Pm->doPayAction(
			pdo(),
			$userInfo,
			$amount,
			configs()->bank,
			$payMethod,
			$payNumber,
			$messages['RUB']
		);
		exit('YES');
	}
}

if(isset($_GET['result_wb']) && $_GET['result_wb'] == 'get') {
	$payMethod = 'wm';

	if(isset($_POST['LMI_PREREQUEST']) && $_POST['LMI_PREREQUEST'] == 1) {
		$userId   = clean($_POST['id'], 'int');
		$userInfo = $Pm->getUser(pdo(), $userId);
		if(empty($userInfo->id)) {
			$Pm->paymentLog($payMethod, "unknown user", pdo(), $userId, 2);
			exit("ERR: User does not exist");
		}

		if(trim($_POST['LMI_PAYEE_PURSE']) != $merchantsSettings->wb_num) {
			$Pm->paymentLog($payMethod, "invalid purse", pdo(), $userId, 2);
			exit("ERR: Invalid purse");
		}

		exit('YES');
	} else {
		$secret_key    = $merchantsSettings->wb_pass1;
		$common_string = $_POST['LMI_PAYEE_PURSE'] . $_POST['LMI_PAYMENT_AMOUNT'] . $_POST['LMI_PAYMENT_NO'] . $_POST['LMI_MODE'] . $_POST['LMI_SYS_INVS_NO'] . $_POST['LMI_SYS_TRANS_NO'] . $_POST['LMI_SYS_TRANS_DATE'] . $secret_key . $_POST['LMI_PAYER_PURSE'] . $_POST['LMI_PAYER_WM'];
		$hash          = strtoupper(hash("sha256", $common_string));

		$amount    = clean($_POST['LMI_PAYMENT_AMOUNT'], 'float');
		$payNumber = clean($_POST['LMI_PAYMENT_NO'], 'int');
		$userId    = clean($_POST['id'], 'int');

		if($hash != $_POST['LMI_HASH']) {
			$Pm->paymentLog($payMethod, "bad sign", pdo(), $userId, 2);
			exit("ERR: Bad key");
		} else {
			$userInfo = $Pm->getUser(pdo(), $userId);
			if(empty($userInfo->id)) {
				$Pm->paymentLog($payMethod, "unknown user", pdo(), $userId, 2);
				exit('Error: [User does not exist]');
			} else {
				if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
					exit('OK');
				}

				$Pm->doPayAction(
					pdo(),
					$userInfo,
					$amount,
					configs()->bank,
					$payMethod,
					$payNumber,
					$messages['RUB']
				);
				exit('OK');
			}
		}
	}
}

if(isset($_GET['result_rb']) && $_GET['result_rb'] == 'get') {
	$payMethod = 'rb';

	$mrh_pass2 = $merchantsSettings->rb_pass2;
	$out_summ  = $_POST["OutSum"];
	$inv_id    = $_POST["InvId"];
	$Shp_zuser = $_POST["Shp_zuser"];
	$crc       = $_POST["SignatureValue"];
	$crc       = strtoupper($crc);
	$my_crc    = strtoupper(
		md5("$out_summ:$inv_id:$mrh_pass2:Shp_zuser=$Shp_zuser")
	);
	if(strtoupper($my_crc) != strtoupper($crc)) {
		$Pm->paymentLog($payMethod, "bad sign", pdo(), $Shp_zuser, 2);
		exit("bad sign\n");
	}
	echo "OK$inv_id\n";

	$amount    = clean($out_summ, 'float');
	$payNumber = clean($inv_id, 'int');
	$userId    = clean($Shp_zuser, 'int');
	$userInfo  = $Pm->getUser(pdo(), $userId);
	if(empty($userInfo->id)) {
		$Pm->paymentLog($payMethod, "unknown user", pdo(), $userId, 2);
		exit('Error: [User does not exist]');
	} else {
		if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
			exit('OK');
		}

		$Pm->doPayAction(
			pdo(),
			$userInfo,
			$amount,
			configs()->bank,
			$payMethod,
			$payNumber,
			$messages['RUB']
		);
		exit('OK');
	}
}

if(isset($_GET) && array_key_exists('method', $_GET)) {

	$payMethod       = 'up';
	$currentCurrency = Payments::getCashierCurrency($payMethod);

	$unitPay = new UnitPay(
		$merchantsSettings->up_type == 1 ? 'unitpay.money' : 'unitpay.ru',
		$merchantsSettings->up_pass2
	);

	try {
		$unitPay->checkHandlerRequest();

		list($method, $params) = [$_GET['method'], $_GET['params']];

		if(!array_key_exists('params', $_GET) || !is_array($_GET['params'])) {
			$Pm->paymentLog($payMethod, 'invalid request', pdo(), 0, 2);
			throw new Exception('Invalid request');
		}

		if($currentCurrency != $params['orderCurrency']) {
			$Pm->paymentLog($payMethod, 'invalid request', pdo(), 0, 2);
			throw new Exception('Invalid request');
		}

		$userId   = clean($params['account'], 'int');
		$userInfo = $Pm->getUser(pdo(), $userId);
		if(empty($userInfo->id)) {
			$Pm->paymentLog($payMethod, 'unknown user', pdo(), $userId, 2);
			throw new Exception('User does not exist');
		}

		switch($method) {
			case 'check':
				echo $unitPay->getSuccessHandlerResponse(
					'Check Success. Ready to pay.'
				);
				break;
			case 'pay':
				$amount    = clean($params['orderSum'], 'float');
				$payNumber = clean($params['unitpayId'], 'int');

				if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
					echo $unitPay->getSuccessHandlerResponse('Pay Success');
					break;
				}

				$Pm->doPayAction(
					pdo(),
					$userInfo,
					$amount,
					configs()->bank,
					$payMethod,
					$payNumber,
					$messages['RUB']
				);
				echo $unitPay->getSuccessHandlerResponse('Pay Success');

				break;
			case 'error':
				echo $unitPay->getSuccessHandlerResponse('Error logged');
				break;
			case 'refund':
				echo $unitPay->getSuccessHandlerResponse('Order canceled');
				break;
		}
	} catch(Exception $e) {
		echo $unitPay->getErrorHandlerResponse($e->getMessage());
	}
	exit();
}

if(isset($_GET['result_ps']) && $_GET['result_ps'] == 'get') {
	$payMethod = 'ps';

	require_once('inc/classes/class.paysera.php');

	try {
		$response = WebToPay::checkResponse(
			$_GET,
			[
				'projectid'     => $merchantsSettings->ps_num,
				'sign_password' => $merchantsSettings->ps_pass,
			]
		);

		$userId    = clean($response['zzz'], 'int');
		$amount    = clean($response['amount'] / 100, 'float');
		$payNumber = clean($response['orderid'], 'int');

		$userInfo = $Pm->getUser(pdo(), $userId);
		if(empty($userInfo->id)) {
			$Pm->paymentLog($payMethod, "unknown user", pdo(), $userId, 2);
			exit("ERR: User does not exist");
		}

		if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
			exit('OK');
		}

		$Pm->doPayAction(
			pdo(),
			$userInfo,
			$amount,
			configs()->bank,
			$payMethod,
			$payNumber,
			$messages['RUB']
		);
		exit('OK');
	} catch(Exception $e) {
		$srt = get_class($e) . ': ' . $e->getMessage();
		$Pm->paymentLog($payMethod, $srt, pdo(), $userId, 2);
		exit("ERR: " . $srt);
	}
}

if(isset($_GET['result_lp']) && $_GET['result_lp'] == 'get') {
	$payMethod       = 'lp';
	$currentCurrency = Payments::getCashierCurrency($payMethod);

	try {
		if(empty($_POST['data']) || empty($_POST['signature'])) {
			throw new Exception('empty data');
		}

		$LiqPay = new LiqPay(
			$merchantsSettings->lp_public_key,
			$merchantsSettings->lp_private_key
		);
		$params = $LiqPay->decode_params($_POST['data']);

		if(
			base64_encode(
				sha1(
					$merchantsSettings->lp_private_key . $_POST['data'] . $merchantsSettings->lp_private_key,
					1
				)
			) != $_POST['signature']
		) {
			throw new Exception('bad sign');
		}

		if(
			empty($params['amount'])
			|| empty($params['currency'])
			|| empty($params['order_id'])
			|| empty($params['status'])
			|| empty($params['action'])
			|| empty($params['info'])
		) {
			throw new Exception('empty data');
		}

		$amount    = clean($params['amount'], 'float');
		$payNumber = clean($params['order_id'], 'int');
		$userId    = clean($params['info'], 'int');

		if($params['action'] != 'pay' || $params['status'] != 'success') {
			throw new Exception('status not success');
		}

		if($params['currency'] != $currentCurrency) {
			throw new Exception('invalid request');
		}

		$userInfo = $Pm->getUser(pdo(), $userId);
		if(empty($userInfo->id)) {
			throw new Exception('unknown user');
		} else {
			if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
				exit('OK');
			}

			$Pm->doPayAction(
				pdo(),
				$userInfo,
				$amount,
				configs()->bank,
				$payMethod,
				$payNumber,
				$messages['RUB']
			);
			exit('OK');
		}
	} catch(Exception $e) {
		if(empty($userId)) {
			$userId = 0;
		}

		$Pm->paymentLog($payMethod, $e->getMessage(), pdo(), $userId, 2);
		http_response_code(500);
		exit($e->getMessage());
	}
}

if(isset($_GET['result_ap']) && $_GET['result_ap'] == 'get') {
	$payMethod       = 'ap';
	$currentCurrency = Payments::getCashierCurrency($payMethod);

	try {
		if(
			empty($_POST['amount'])
			|| empty($_POST['merchant_id'])
			|| empty($_POST['currency'])
			|| empty($_POST['pay_id'])
			|| empty($_POST['sign'])
			|| empty($_POST['status'])
			|| empty($_POST['user_id'])
		) {
			throw new Exception('empty data');
		}

		$amount    = clean($_POST['amount'], 'float');
		$payNumber = clean($_POST['pay_id'], 'int');
		$userId    = clean($_POST['user_id'], 'int');

		if($_POST['status'] != 'paid') {
			exit();
		}

		if($_POST['currency'] != $currentCurrency) {
			throw new Exception('invalid request');
		}

		$sign = md5(
			implode(
				':',
				[
					$_POST['merchant_id'],
					$_POST['amount'],
					$_POST['pay_id'],
					$merchantsSettings->ap_private_key
				]
			)
		);

		if($sign != $_POST['sign']) {
			throw new Exception('bad sign');
		}

		$userInfo = $Pm->getUser(pdo(), $userId);
		if(empty($userInfo->id)) {
			throw new Exception('unknown user');
		} else {
			if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
				exit('OK');
			}

			$Pm->doPayAction(
				pdo(),
				$userInfo,
				$amount,
				configs()->bank,
				$payMethod,
				$payNumber,
				$messages['RUB']
			);
			exit('OK');
		}
	} catch(Exception $e) {
		if(empty($userId)) {
			$userId = 0;
		}

		$Pm->paymentLog($payMethod, $e->getMessage(), pdo(), $userId, 2);
		http_response_code(500);
		exit($e->getMessage());
	}
}

if(isset($_GET['enot']) && $_GET['enot'] == 'pay') {
	$payMethod       = 'enot';
	$currentCurrency = Payments::getCashierCurrency($payMethod);

	try {
		if(
			empty($_POST['amount'])
			|| empty($_POST['merchant'])
			|| empty($_POST['merchant_id'])
			|| empty($_POST['currency'])
			|| empty($_POST['custom_field'])
			|| empty($_POST['sign_2'])
		) {
			throw new Exception('empty data');
		}

		$amount    = clean($_POST['amount'], 'float');
		$payNumber = clean($_POST['merchant_id'], 'int');
		$userId    = clean($_POST['custom_field'], 'int');

		if($_POST['currency'] != $currentCurrency) {
			throw new Exception('invalid request');
		}

		$sign = md5(
			$_POST['merchant'] . ':' . $_POST['amount'] . ':' . $merchantsSettings->enot_key2 . ':' . $_POST['merchant_id']
		);

		if($sign != $_POST['sign_2']) {
			throw new Exception('bad sign');
		}

		$userInfo = $Pm->getUser(pdo(), $userId);
		if(empty($userInfo->id)) {
			throw new Exception('unknown user');
		} else {
			if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
				exit('OK');
			}

			$Pm->doPayAction(
				pdo(),
				$userInfo,
				$amount,
				configs()->bank,
				$payMethod,
				$payNumber,
				$messages['RUB']
			);
			exit('OK');
		}
	} catch(Exception $e) {
		if(empty($userId)) {
			$userId = 0;
		}

		$Pm->paymentLog($payMethod, $e->getMessage(), pdo(), $userId, 2);
		http_response_code(500);
		exit($e->getMessage());
	}
}

if(isset($_GET['payanyway']) && $_GET['payanyway'] == 'pay') {
	$payMethod = 'payanyway';

	try {
		require_once __DIR__ . '/../../inc/classes/PayAnyWay/moneta-sdk-lib/autoload.php';

		$monetaSDK = new Moneta\MonetaSdk();
		$monetaSDK->setSettingValue('monetasdk_account_id', $merchantsSettings->payanyway_id);
		$monetaSDK->setSettingValue('monetasdk_account_code', $merchantsSettings->payanyway_code);
		$monetaSDK->setSettingValue('monetasdk_connection_type', 'json');

		exit($monetaSDK->processInputData()->render);
	} catch(Exception $e) {
		if(empty($userId)) {
			$userId = 0;
		}

		$Pm->paymentLog($payMethod, $e->getMessage(), pdo(), $userId, 2);
		http_response_code(500);
		exit($e->getMessage());
	}
}

if(isset($_GET['yookassa']) && $_GET['yookassa'] == 'pay') {
	$payMethod       = 'yookassa';
	$currentCurrency = Payments::getCashierCurrency($payMethod);

	try {
		$source      = file_get_contents('php://input');
		$requestBody = json_decode($source, true);

		require_once __DIR__ . '/../../inc/classes/YooKassa/lib/autoload.php';

		$notification = ($requestBody['event'] === YooKassa\Model\NotificationEventType::PAYMENT_SUCCEEDED)
			? new YooKassa\Model\Notification\NotificationSucceeded($requestBody)
			: new YooKassa\Model\Notification\NotificationWaitingForCapture($requestBody);

		$payment = $notification->getObject();

		if(
			empty($payment->id)
			|| empty($payment->amount->value)
			|| empty($payment->amount->currency)
			|| empty($payment->metadata->user_id)
		) {
			throw new Exception('empty data');
		}

		$amount    = clean($payment->amount->value, 'float');
		$payNumber = clean($payment->id, 'int');
		$userId    = clean($payment->metadata->user_id, 'int');

		if($payment->amount->currency != $currentCurrency) {
			throw new Exception('invalid request');
		}

		$userInfo = $Pm->getUser(pdo(), $userId);

		if(empty($userInfo->id)) {
			throw new Exception('unknown user');
		} else {
			if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
				exit('OK');
			}

			$Pm->doPayAction(
				pdo(),
				$userInfo,
				$amount,
				configs()->bank,
				$payMethod,
				$payNumber,
				$messages['RUB']
			);
			exit('OK');
		}
	} catch(Exception $e) {
		if(empty($userId)) {
			$userId = 0;
		}

		$Pm->paymentLog($payMethod, $e->getMessage(), pdo(), $userId, 2);
		http_response_code(500);
		exit($e->getMessage());
	}
}

if(isset($_GET['paypalych']) && $_GET['paypalych'] == 'pay') {
	$payMethod       = 'paypalych';
	$currentCurrency = Payments::getCashierCurrency($payMethod);

	try {
		if(
			empty($_POST["InvId"]) || empty($_POST["OutSum"]) || empty($_POST["Status"])
			|| empty($_POST["CurrencyIn"]) || empty($_POST["custom"]) || empty($_POST["SignatureValue"])
			|| empty($_POST["Commission"])
		) {
			throw new Exception('empty data');
		}

		if(
			strtoupper($_POST["SignatureValue"])
			!= strtoupper(md5($_POST['OutSum'] . ":" . $_POST["InvId"] . ":" . $merchantsSettings->paypalych_key))
		) {
			throw new Exception('bad sign');
		}

		if($_POST["CurrencyIn"] != $currentCurrency) {
			throw new Exception('invalid request');
		}

		if($_POST["Status"] != 'SUCCESS') {
			throw new Exception('Bad status');
		}

		$amount    = clean($_POST['OutSum'] - $_POST["Commission"], 'float');
		$payNumber = clean($_POST["InvId"], 'int');
		$userId    = clean($_POST["custom"], 'int');

		$userInfo = $Pm->getUser(pdo(), $userId);

		if(empty($userInfo->id)) {
			throw new Exception('unknown user');
		} else {
			if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
				exit('OK');
			}

			$Pm->doPayAction(
				pdo(),
				$userInfo,
				$amount,
				configs()->bank,
				$payMethod,
				$payNumber,
				$messages['RUB']
			);
			exit('OK');
		}
	} catch(Exception $e) {
		if(empty($userId)) {
			$userId = 0;
		}

		$Pm->paymentLog($payMethod, $e->getMessage(), pdo(), $userId, 2);
		http_response_code(500);
		exit($e->getMessage());
	}
}

if(isset($_GET['payok']) && $_GET['payok'] == 'pay') {
	$payMethod       = 'payok';
	$currentCurrency = Payments::getCashierCurrency($payMethod);

	try {
		if(
			empty($_POST["desc"]) || empty($_POST["currency"]) || empty($_POST["shop"])
			|| empty($_POST["payment_id"]) || empty($_POST["custom"]) || empty($_POST["amount"])
			|| empty($_POST["sign"])
		) {
			throw new Exception('empty data');
		}

		if(
			$_POST["sign"] != md5(
				$merchantsSettings->payok_key . '|'
				. $_POST['desc'] . "|"
				. $_POST["currency"] . "|"
				. $_POST["shop"] . "|"
				. $_POST["payment_id"] . "|"
				. $_POST["amount"]
			)
		) {
			throw new Exception('bad sign');
		}

		if($_POST["currency"] != $currentCurrency) {
			throw new Exception('invalid request');
		}

		$amount    = clean($_POST['amount'], 'float');
		$payNumber = clean($_POST["payment_id"], 'int');
		$userId    = clean($_POST["custom"]["custom"], 'int');

		$userInfo = $Pm->getUser(pdo(), $userId);

		if(empty($userInfo->id)) {
			throw new Exception('unknown user');
		} else {
			if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
				exit('OK');
			}

			$Pm->doPayAction(
				pdo(),
				$userInfo,
				$amount,
				configs()->bank,
				$payMethod,
				$payNumber,
				$messages['RUB']
			);
			exit('OK');
		}
	} catch(Exception $e) {
		if(empty($userId)) {
			$userId = 0;
		}

		$Pm->paymentLog($payMethod, $e->getMessage(), pdo(), $userId, 2);
		http_response_code(500);
		exit($e->getMessage());
	}
}

if(isset($_GET['primepayments']) && $_GET['primepayments'] == 'pay') {
	$payMethod       = 'primepayments';
	$currentCurrency = Payments::getCashierCurrency($payMethod);

	try {
		if(
			empty($_POST["sign"]) || empty($_POST["orderID"]) || empty($_POST["payWay"])
			|| empty($_POST["innerID"]) || empty($_POST["sum"]) || empty($_POST["webmaster_profit"])
			|| empty($_POST["currency"]) || empty($_POST["action"])
		) {
			throw new Exception('empty data');
		}

		if(
			$_POST['sign'] != md5(
				$merchantsSettings->primepayments_key_2
				. $_POST['orderID']
				. $_POST['payWay']
				. $_POST['innerID']
				. $_POST['sum']
				. $_POST['webmaster_profit']
			)
		) {
			throw new Exception('bad sign');
		}

		if($_POST["action"] != 'order_payed') {
			throw new Exception('invalid request');
		}

		if($_POST["currency"] != $currentCurrency) {
			throw new Exception('invalid request');
		}

		$amount    = clean($_POST['sum'], 'float');
		$payNumber = clean($_POST["orderID"], 'int');
		$userId    = clean($_POST["innerID"], 'int');

		$userInfo = $Pm->getUser(pdo(), $userId);

		if(empty($userInfo->id)) {
			throw new Exception('unknown user');
		} else {
			if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
				exit('OK');
			}

			$Pm->doPayAction(
				pdo(),
				$userInfo,
				$amount,
				configs()->bank,
				$payMethod,
				$payNumber,
				$messages['RUB']
			);
			exit('OK');
		}
	} catch(Exception $e) {
		if(empty($userId)) {
			$userId = 0;
		}

		$Pm->paymentLog($payMethod, $e->getMessage(), pdo(), $userId, 2);
		http_response_code(500);
		exit($e->getMessage());
	}
}


if(isset($_GET['lava']) && $_GET['lava'] == 'pay') {
	$payMethod = 'lava';

	try {
		$source = file_get_contents('php://input');
		$data = json_decode($source, true);
		ksort($data);

		$signature = $_SERVER['HTTP_AUTHORIZATION'];

		if(
			empty($signature) || empty($data["status"]) || empty($data["order_id"])
			|| empty($data["amount"]) || empty($data["custom_fields"])
		) {
			throw new Exception('empty data');
		}

		if(
			$signature != hash_hmac(
				'sha256',
				json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE),
				$merchantsSettings->lava_key_2
			)
		) {
			throw new Exception('bad sign');
		}

		if($data["status"] != 'success') {
			throw new Exception('invalid request');
		}

		$amount    = clean($data['amount'], 'float');
		$payNumber = clean($data["order_id"], 'int');
		$userId    = clean($data["custom_fields"], 'int');

		$userInfo = $Pm->getUser(pdo(), $userId);

		if(empty($userInfo->id)) {
			throw new Exception('unknown user');
		} else {
			if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
				exit('OK');
			}

			$Pm->doPayAction(
				pdo(),
				$userInfo,
				$amount,
				configs()->bank,
				$payMethod,
				$payNumber,
				$messages['RUB']
			);
			exit('OK');
		}
	} catch(Exception $e) {
		if(empty($userId)) {
			$userId = 0;
		}

		$Pm->paymentLog($payMethod, $e->getMessage(), pdo(), $userId, 2);
		http_response_code(500);
		exit($e->getMessage());
	}
}

if(isset($_GET['result_aifo']) && $_GET['result_aifo'] == 'get') {
	$payMethod = 'aifo';

	try {
		// Проверка IP сервера AIFO
		function getIP() {
			if(isset($_SERVER["HTTP_CF_CONNECTING_IP"])) {
				$_SERVER['REMOTE_ADDR'] = $_SERVER["HTTP_CF_CONNECTING_IP"];
			}
			if(isset($_SERVER['HTTP_X_REAL_IP'])) {
				return $_SERVER['HTTP_X_REAL_IP'];
			}
			return $_SERVER['REMOTE_ADDR'];
		}

		if(!in_array(getIP(), array('77.83.102.155'))) {
			throw new Exception('hacking attempt');
		}

		if(
			empty($_POST['sum'])
			|| empty($_POST['invoice'])
			|| empty($_POST['http_auth_signature'])
		) {
			throw new Exception('empty data');
		}

		$amount    = clean($_POST['sum'], 'float');
		$payNumber = clean($_POST['invoice'], 'int');

		// Получаем ID пользователя из pay_id
		// pay_id формируется как userId (7 цифр) + timestamp + случайное число
		$payIdStr = (string)$payNumber;
		$userId = (int)substr($payIdStr, 0, 7);

		// Формируем подпись для проверки: SHA256(ID Магазину:Сума:Секретний ключ:Номер Рахунку)
		$sign = hash('sha256', $merchantsSettings->aifo_shop_id . ':' . $_POST['sum'] . ':' . $merchantsSettings->aifo_secret_key . ':' . $_POST['invoice']);

		if($sign != $_POST['http_auth_signature']) {
			throw new Exception('bad sign');
		}

		$userInfo = $Pm->getUser(pdo(), $userId);
		if(empty($userInfo->id)) {
			throw new Exception('unknown user');
		} else {
			if($Pm->issetPay(pdo(), $payMethod, $payNumber)) {
				exit('OK');
			}

			$Pm->doPayAction(
				pdo(),
				$userInfo,
				$amount,
				configs()->bank,
				$payMethod,
				$payNumber,
				$messages['RUB']
			);
			exit('OK');
		}
	} catch(Exception $e) {
		if(empty($userId)) {
			$userId = 0;
		}

		$Pm->paymentLog($payMethod, $e->getMessage(), pdo(), $userId, 2);
		http_response_code(500);
		exit($e->getMessage());
	}
}

$fail = '';
if(
	(isset($_GET['result_wo']) && $_GET['result_wo'] == 'fail')
	|| (isset($_GET['result_ik']) && $_GET['result_ik'] == 'fail')
	|| (isset($_GET['result']) && $_GET['result'] == 'fail')
	|| (isset($_GET['result_rb']) && $_GET['result_rb'] == 'fail')
	|| (isset($_GET['result_wb']) && $_GET['result_wb'] == 'fail')
	|| (isset($_GET['result_ps']) && $_GET['result_ps'] == 'fail')
	|| (isset($_GET['result_aifo']) && $_GET['result_aifo'] == 'fail')
	|| (isset($_GET['method']) && $_GET['method'] == 'ERROR')
) {
	$fail = 1;
}

$success = '';
if(
	(isset($_GET['result_ps']) && $_GET['result_ps'] == 'success')
	|| (isset($_GET['result_rb']) && $_GET['result_rb'] == 'success')
	|| (isset($_GET['result_wb']) && $_GET['result_wb'] == 'success')
	|| (isset($_GET['result']) && $_GET['result'] == 'success')
	|| (isset($_GET['result_ik']) && $_GET['result_ik'] == 'success')
	|| (isset($_GET['result_qw']) && $_GET['result_qw'] == 'success')
	|| (isset($_GET['result_ya']) && $_GET['result_ya'] == 'success')
	|| (isset($_GET['result_wo']) && $_GET['result_wo'] == 'success')
	|| (isset($_GET['result_aifo']) && $_GET['result_aifo'] == 'success')
) {
	$success = 1;
}

if(!is_auth()) {
	show_error_page('not_auth');
}

tpl()->load_template('elements/title.tpl');
tpl()->set("{title}", page()->title);
tpl()->set("{name}", configs()->name);
tpl()->compile('title');
tpl()->clear();

tpl()->load_template('head.tpl');
tpl()->set("{title}", tpl()->result['title'], false);
tpl()->set("{site_name}", configs()->name);
tpl()->set("{image}", page()->image);
tpl()->set("{robots}", page()->robots);
tpl()->set("{type}", page()->kind);
tpl()->set("{description}", page()->description);
tpl()->set("{keywords}", page()->keywords);
tpl()->set("{url}", page()->full_url);
tpl()->set("{other}", '');
tpl()->set("{token}", token());
tpl()->set("{cache}", configs()->cache);
tpl()->set("{template}", configs()->template);
tpl()->compile('content');
tpl()->clear();

$menu = tpl()->get_menu();

$nav = [
	$PI->to_nav('main', 0, 0),
	$PI->to_nav('users', 0, 0),
	$PI->to_nav('profile', 0, user()->id, user()->login),
	$PI->to_nav('purse', 1, 0)
];
$nav = tpl()->get_nav($nav, 'elements/nav_li.tpl');

include_once __DIR__ . '/../../inc/authorized.php';

if(isset($_GET['price'])) {
	$price = clean($_GET['price'], 'float');
} else {
	$price = '';
}

$bonusesActivity = pdo()->query("SELECT bonuses FROM config__secondary LIMIT 1")
	->fetch(PDO::FETCH_OBJ)
	->bonuses;

$bonuses = unserialize(
	pdo()->query("SELECT data FROM config__strings WHERE id = 3 LIMIT 1")
		->fetch(PDO::FETCH_OBJ)
		->data
);

$merchants = getMerchants();

tpl()->load_template('/home/purse.tpl');
tpl()->set("{template}", configs()->template);
tpl()->set("{profile_id}", user()->id);
tpl()->set("{balance}", user()->shilings);
tpl()->set("{proc}", user()->proc);
tpl()->set("{price}", $price);
tpl()->set("{fail}", $fail);
tpl()->set("{success}", $success);
tpl()->set("{login}", $_SESSION['login']);
tpl()->set("{bonusesActivity}", $bonusesActivity);
tpl()->compile('content');
tpl()->clear();