# Инструкция по настройке платежной системы AIFO

## Описание
AIFO - это платежная система, которая поддерживает различные способы оплаты: банковские карты, ЮMoney, Qiwi, SMS и другие.

## Требования
- GameCMS 3.664 или выше
- PHP 7.0 или выше
- MySQL/MariaDB
- Доступ к админ-панели сайта

## Установка

### Шаг 1: Проверка базы данных

Если вы устанавливаете движок с нуля, поля AIFO уже будут созданы автоматически при установке.

Если у вас уже установлен движок, выполните SQL миграцию:

```sql
-- Проверьте наличие полей
SHOW COLUMNS FROM `config__bank` LIKE 'aifo%';

-- Если полей нет, выполните:
ALTER TABLE `config__bank` ADD COLUMN `aifo` INT(1) NOT NULL DEFAULT '2' AFTER `enot_key2`;
ALTER TABLE `config__bank` ADD COLUMN `aifo_shop_id` VARCHAR(255) NOT NULL DEFAULT '' AFTER `aifo`;
ALTER TABLE `config__bank` ADD COLUMN `aifo_secret_key` VARCHAR(255) NOT NULL DEFAULT '' AFTER `aifo_public_key`;
```

**Примечание:** Если какое-то поле уже существует, вы получите ошибку "Дублирующееся имя столбца" - это нормально, просто пропустите эту команду.

### Шаг 2: Получение данных от AIFO

1. Зарегистрируйтесь на сайте [https://aifo.pro](https://aifo.pro)
2. Создайте проект/кассу в личном кабинете
3. Получите следующие данные:
   - **ID каси (Shop ID)** - идентификатор вашей кассы
   - **Секретный ключ (Secret Key)** - секретный ключ для создания платежей и проверки callback'ов

### Шаг 3: Настройка в админ-панели

1. Войдите в админ-панель вашего сайта
2. Перейдите в раздел **Настройки → Платежи** (`/admin/payments`)
3. Найдите блок **AIFO**
4. Нажмите кнопку **"Включить"** для активации платежной системы
5. Заполните поля:
   - **ID каси (Shop ID)** - вставьте ID каси из личного кабинета AIFO
   - **Секретний ключ** - вставьте секретный ключ
6. Нажмите кнопку **"Изменить"** для сохранения настроек

### Шаг 4: Настройка в личном кабинете AIFO

В личном кабинете AIFO настройте следующие URL:

1. **URL оповещения (Result URL / Webhook URL):**
   ```
   https://ваш-сайт.ru/purse?result_aifo=get
   ```
   Замените `ваш-сайт.ru` на адрес вашего сайта.

2. **URL успешной оплаты (Success URL):**
   ```
   https://ваш-сайт.ru/purse?result_aifo=success
   ```

3. **URL неуспешной оплаты (Fail URL):**
   ```
   https://ваш-сайт.ru/purse?result_aifo=fail
   ```

**Важно:** 
- Используйте полный адрес с `https://`
- Не используйте `http://` - это небезопасно
- Убедитесь, что URL доступны из интернета

### Шаг 5: Проверка IP адреса (рекомендуется)

AIFO отправляет уведомления с IP адреса: **77.83.102.155**

В коде уже реализована проверка этого IP адреса для безопасности. Если вы хотите отключить проверку IP (не рекомендуется), обратитесь к разработчику.

## Проверка работы

1. Перейдите на страницу пополнения баланса (`/purse`)
2. Выберите способ оплаты **AIFO**
3. Введите сумму пополнения
4. Нажмите кнопку оплаты
5. Вы должны быть перенаправлены на страницу оплаты AIFO

## Устранение неполадок

### Проблема: Настройки не сохраняются

**Решение:**
1. Убедитесь, что все поля заполнены
2. Проверьте, что поля AIFO созданы в базе данных (см. Шаг 1)
3. Проверьте права доступа к базе данных
4. Проверьте логи ошибок PHP

### Проблема: Платежи не проходят

**Решение:**
1. Проверьте правильность URL в настройках AIFO
2. Убедитесь, что URL доступны из интернета (не localhost)
3. Проверьте правильность ключей (ID каси и секретный ключ)
4. Проверьте логи платежей в админ-панели

### Проблема: Ошибка "hacking attempt" в логах

**Решение:**
Это означает, что callback приходит не с IP адреса AIFO. Проверьте:
1. Правильность настройки URL в личном кабинете AIFO
2. Наличие прокси-серверов (Cloudflare и т.д.) - может потребоваться настройка проверки IP

## Дополнительная информация

- Документация AIFO: [https://aifo.pro/docs](https://aifo.pro/docs)
- Поддержка AIFO: обратитесь в поддержку через личный кабинет

## Технические детали

- Алгоритм подписи: SHA256 (рекомендуется)
- Формат pay_id: userId (7 цифр) + timestamp + случайное число
- Валюта по умолчанию: UAH (можно изменить в настройках)

## Безопасность

- Все callback'и проверяются по IP адресу сервера AIFO
- Подписи проверяются с использованием SHA256
- Секретный ключ никогда не передается клиенту
- Рекомендуется использовать HTTPS для всех URL

---

**Версия инструкции:** 1.0  
**Дата обновления:** 2026
