# AIFO Payment Form Module

Модуль для інтеграції платіжної форми AIFO.PRO на ваш сайт.

## Файли

- **payment_form.php** - Генератор платіжної форми та функції для роботи з API
- **payment_handler.php** - Обробник сповіщень про платежі від AIFO
- **README.md** - Документація

## Швидкий старт

### 1. Налаштування

Відкрийте `payment_form.php` та вкажіть ваші дані:

```php
define('SHOP_ID', '1'); // ID вашої каси
define('SECRET_KEY', 'your_secret_key_here'); // Секретний ключ
define('SIGNATURE_TYPE', 2); // SHA256 (рекомендовано)
```

### 2. Використання форми

Відкрийте `payment_form.php` в браузері або підключіть до вашого сайту:

```php
<?php
require_once 'modules/payment_form.php';

// Параметри платежу
$shop_id = SHOP_ID;
$pay_id = 'ORDER_' . time(); // Унікальний номер
$amount = 100.00; // Сума в гривнях
$desc = 'Опис платежу';

// Генерація URL
$payment_url = generatePaymentUrl(
    $shop_id, 
    $pay_id, 
    $amount, 
    SECRET_KEY, 
    SIGNATURE_TYPE, 
    $desc
);

// Перенаправлення
header('Location: ' . $payment_url);
exit;
?>
```

### 3. Налаштування обробника платежів

1. Відкрийте налаштування вашої каси на https://aifo.pro/kassa
2. Вкажіть URL для сповіщень: `https://your-site.com/modules/payment_handler.php`
3. Переконайтеся що `SECRET_KEY` вказаний правильно в `payment_handler.php`

## API Документація

Повна документація доступна на: https://aifo.pro/docs

### Параметри платежу

| Параметр | Опис | Обов'язковий |
|----------|------|--------------|
| shop_id | ID каси | Так |
| pay_id | Номер рахунку | Так |
| amount | Сума платежу | Так |
| sign | Підпис MD5/SHA256/SHA1/SHA512/SHA384/RIPEMD160 | Так |
| desc | Опис платежу | Ні |

### Формула підпису

```
sign = hash(SHOP_ID:AMOUNT:SECRET_KEY:PAY_ID)
```

Рекомендований алгоритм: **SHA256**

### Приклад генерації підпису

```php
$sign_string = "1:100.00:your_secret_key:ORDER_12345";
$sign = hash('sha256', $sign_string);
```

## Безпека

1. **НЕ публікуйте SECRET_KEY** - він має бути доступний тільки вам
2. **Перевіряйте IP адресу** - використовуйте функцію `validateAifoIp()`
3. **Перевіряйте підпис** - завжди перевіряйте підпис від AIFO
4. **Перевіряйте суму** - переконайтеся що сума відповідає очікуваній
5. **Перевіряйте дублікати** - не обробляйте один платіж двічі

## Приклад обробки платежу

```php
<?php
require_once 'modules/payment_handler.php';

// Після перевірки підпису та IP:
$invoice_id = $_POST['invoice'];
$amount = $_POST['sum'];

// Ваша логіка:
// - Оновлення статусу в БД
// - Відправка email
// - Оновлення балансу
// - тощо

echo "OK"; // Обов'язкова відповідь для AIFO
?>
```

## Підтримка

Документація: https://aifo.pro/docs
API: https://aifo.pro/account/api
