<?php
/**
 * AIFO Payment Handler
 * Обробник сповіщень про платежі від AIFO.PRO
 * 
 * Використання:
 * 1. Налаштуйте URL для сповіщень в налаштуваннях каси: https://your-site.com/modules/payment_handler.php
 * 2. Переконайтеся що SECRET_KEY вказаний правильно
 * 
 * @version 1.0
 * @author AIFO.PRO
 */

// Підключення основного файлу з функціями
require_once __DIR__ . '/payment_form.php';

// ============================================
// ОБРОБКА СПОВІЩЕНЬ ВІД AIFO
// ============================================

// Отримуємо дані від AIFO
$post_data = $_POST;

// Логування для діагностики (опціонально)
$log_file = __DIR__ . '/payment_handler.log';
$log_entry = date('Y-m-d H:i:s') . " - POST data: " . json_encode($post_data) . "\n";
@file_put_contents($log_file, $log_entry, FILE_APPEND);

// Перевірка наявності обов'язкових полів
if (!isset($post_data['sum']) || !isset($post_data['invoice']) || !isset($post_data['http_auth_signature'])) {
	http_response_code(400);
	die('Missing required parameters');
}

// Перевірка IP адреси (рекомендується для безпеки)
if (!validateAifoIp()) {
	http_response_code(403);
	$log_entry = date('Y-m-d H:i:s') . " - Invalid IP: " . ($_SERVER['REMOTE_ADDR'] ?? 'unknown') . "\n";
	@file_put_contents($log_file, $log_entry, FILE_APPEND);
	die('Invalid IP address');
}

// Перевірка підпису
if (!verifySignature($post_data, SECRET_KEY, SIGNATURE_TYPE)) {
	http_response_code(403);
	$log_entry = date('Y-m-d H:i:s') . " - Invalid signature for invoice: " . $post_data['invoice'] . "\n";
	@file_put_contents($log_file, $log_entry, FILE_APPEND);
	die('Invalid signature');
}

// Дані платежу
$invoice_id = $post_data['invoice']; // Номер рахунку
$amount = floatval($post_data['sum']); // Сума платежу
$signature = $post_data['http_auth_signature']; // Підпис

// ============================================
// ВАША ЛОГІКА ОБРОБКИ ПЛАТЕЖУ
// ============================================

// Приклад: Збереження в БД
// $db = new PDO('mysql:host=localhost;dbname=your_db', 'user', 'password');
// $stmt = $db->prepare("UPDATE orders SET status = 'paid', paid_at = NOW() WHERE order_id = ? AND amount = ?");
// $stmt->execute([$invoice_id, $amount]);

// Приклад: Відправка email
// mail($customer_email, 'Платіж отримано', "Ваш платіж на суму {$amount} ₴ успішно отримано!");

// Приклад: Оновлення балансу користувача
// updateUserBalance($user_id, $amount);

// Логування успішної обробки
$log_entry = date('Y-m-d H:i:s') . " - Payment processed successfully. Invoice: {$invoice_id}, Amount: {$amount} ₴\n";
@file_put_contents($log_file, $log_entry, FILE_APPEND);

// Відповідь для AIFO (обов'язково!)
// AIFO очікує відповідь "OK" для підтвердження отримання сповіщення
echo "OK";

?>
