# Telegram бот для продажу цифрових товарів

Telegram бот для продажу цифрових товарів з інтеграцією AIFO Payment System.

## Особливості

- ✅ Інтеграція з AIFO Payment System для безпечних платежів
- ✅ Поповнення балансу через AIFO API
- ✅ Підтримка файлових та текстових товарів
- ✅ Управління кількістю товарів (stock)
- ✅ Адмін панель для управління товарами та категоріями
- ✅ Статистика продажів
- ✅ Повний переклад на українську мову
- ✅ Обробка помилок та детальне логування

## Встановлення

### Вимоги

- Python 3.7 або вище
- Telegram бот токен (отримайте від @BotFather)
- AIFO магазин (shop_id та secret_key)

### Крок 1: Встановлення залежностей

```bash
pip install pyTelegramBotAPI requests tinydb
```

### Крок 2: Налаштування конфігурації

Відредагуйте файл `config.py`:

```python
TOKEN = 'ваш_telegram_bot_token'
AIFO_API_URL = 'https://aifo.pro/api/v1'
AIFO_SHOP_ID = ваш_shop_id
AIFO_SECRET_KEY = 'ваш_secret_key'
ADMIN_ID = ваш_telegram_user_id
CHANNEL_ID = 'ваш_channel_id'
```

**Важливо:**
- `TOKEN` - отримайте від @BotFather в Telegram
- `AIFO_SHOP_ID` та `AIFO_SECRET_KEY` - отримайте в панелі AIFO
- `ADMIN_ID` - ваш Telegram user ID (можна дізнатися через @userinfobot)
- `CHANNEL_ID` - ID каналу для зберігання файлів товарів (створити приватний канал, додати бота як адміністратора)

### Крок 3: Налаштування AIFO

1. Створіть магазин в системі AIFO
2. Встановіть тип мерчанта: `telegram`
3. Отримайте `shop_id` та `secret_key`
4. Налаштуйте URL (див. [SETUP_AIFO.md](SETUP_AIFO.md))

### Крок 4: Запуск бота

**Windows:**
```bash
python bot.py
```

**Linux/macOS:**
```bash
python3 bot.py
```

Детальні інструкції для Linux: див. [START_BOT.md](START_BOT.md)

## Використання

### Команди для користувачів

- `/start` - Початок роботи з ботом
- `📦 Товари` - Перегляд товарів по категоріях
- `📁 Наявність` - Перегляд всіх доступних товарів
- `👤 Профіль` - Перегляд профілю, балансу та історії покупок
- `💰 Поповнити баланс` - Поповнення балансу через AIFO

### Команди для адміністратора

- `/admin` - Адмін панель з можливостями:
  - 📊 Статистика продажів
  - 📦 Управління товарами (додавання, видалення)
  - 📁 Управління категоріями (додавання, видалення)

### Створення товару

1. Зайдіть в адмін панель (`/admin`)
2. Оберіть "➕ Додати товар"
3. Виберіть категорію
4. Введіть назву товару
5. Введіть опис товару
6. Введіть ціну (₴)
7. Введіть кількість товарів для продажу
8. Надішліть файли (кожен файл = один товар) або текст

**Підтримувані типи файлів:**
- 📄 Документи
- 🖼 Фото
- 🎥 Відео
- 🎵 Аудіо
- 🎤 Голосові повідомлення
- 📝 Текст (для текстових товарів)

**Важливо:** Кількість надісланих файлів має відповідати вказаній кількості товарів. Кожен файл вважається окремим товаром.

## Структура файлів

```
telegram bot/
├── bot.py          # Основний файл бота
├── config.py       # Конфігурація (токени, ключі)
├── database.json   # База даних (створюється автоматично)
├── bot.log         # Логи роботи бота
├── README.md       # Ця інструкція
├── SETUP_AIFO.md   # Налаштування AIFO
└── START_BOT.md    # Запуск бота на Linux
```

## Налаштування AIFO URL

Детальна інформація про налаштування URL в панелі AIFO: [SETUP_AIFO.md](SETUP_AIFO.md)

**Коротко:**
- **URL сповіщення:** Може бути порожнім (бот сам відправляє webhook)
- **Успішний URL:** Порожній або `https://t.me/ваш_бот`
- **Неуспішний URL:** Порожній або `https://t.me/ваш_бот`

## Безпека

- Всі платежі захищені підписом SHA256
- Валідація всіх вхідних даних
- Обробка помилок та логування
- Захист від повторної обробки платежів
- Перевірка stock перед покупкою

## Логування

Логи зберігаються в файлі `bot.log` з кодуванням UTF-8.

Рівень логування: `INFO`

Формат: `%(asctime)s - %(levelname)s - %(message)s`

## Управління товарами

### Stock (кількість товарів)

- При створенні товару вказується кількість доступних одиниць
- Кожен надісланий файл = один товар
- Кількість автоматично зменшується при покупці
- Товар стає недоступним коли stock = 0

### Типи товарів

1. **Файлові товари:**
   - Надішліть файли (документи, фото, відео, аудіо)
   - Кожен файл = один товар
   - Покупці отримують файл після оплати

2. **Текстові товари:**
   - Надішліть текст замість файлу
   - Текст = один товар
   - Покупці отримують текст після оплати

## Підтримка

Якщо виникли проблеми:

1. Перевірте правильність налаштувань в `config.py`
2. Перевірте доступність AIFO API
3. Перевірте валідність токенів та ключів
4. Перевірте логи в файлі `bot.log`
5. Перевірте що бот доданий в канал як адміністратор (для `CHANNEL_ID`)
6. Перевірте що тип мерчанта в AIFO встановлено як `telegram`

## Ліцензія

Цей проект розповсюджується без обмежень. Використовуйте на свій розсуд.

## Автор

Розроблено для продажу цифрових товарів через Telegram з інтеграцією AIFO Payment System.
