# Налаштування магазину в AIFO для Telegram бота

Ця інструкція допоможе правильно налаштувати магазин в системі AIFO для роботи з Telegram ботом.

## Крок 1: Створення магазину в AIFO

1. Увійдіть в панель управління AIFO
2. Перейдіть в розділ "Магазини" / "Kassa"
3. Створіть новий магазин або використайте існуючий

## Крок 2: Основні налаштування магазину

### Обов'язкові параметри:

- **Назва магазину:** Будь-яка назва (наприклад: "Telegram Bot Shop")
- **Тип мерчанта:** `telegram` або `api`
- **Статус:** `Активовано` (Status = 1)
- **Валюта:** UAH (гривні)
- **Режим підпису:** SHA256 (рекомендовано)

## Крок 3: Налаштування URL

### URL сповіщення (Webhook URL / Notification URL)

**Для Telegram бота це поле НЕ ОБОВ'ЯЗКОВЕ**, оскільки бот сам відправляє webhook через API метод `telegram/webhook` після того, як користувач натискає кнопку "Перевірити оплату".

**Варіанти:**

1. **Залишити порожнім** (рекомендовано для Telegram бота)
   - Бот використовує API метод перевірки статусу
   - Webhook відправляється вручну через API

2. **Вказати URL (якщо потрібні автоматичні сповіщення):**
   ```
   https://ваш-домен.com/api/v1/telegram/webhook
   ```
   - Використовується, якщо AIFO може відправляти автоматичні webhook
   - Має приймати POST запити з даними платежу

**Примітка:** Якщо ви залишите порожнім, бот все одно працюватиме через API метод перевірки.

### Успішний URL (Success URL)

URL, на який користувач буде перенаправлений після **успішної оплати** через платіжне посилання.

**Варіанти:**

1. **Стандартна сторінка AIFO (залишити порожнім):**
   - Використовується сторінка успіху AIFO за замовчуванням

2. **Ваша сторінка успіху:**
   ```
   https://ваш-домен.com/pay/success
   ```

3. **Посилання на Telegram бота:**
   ```
   https://t.me/ваш_бот
   ```
   - Користувач повертається до бота після оплати

4. **Посилання з параметрами:**
   ```
   https://t.me/ваш_бот?start=payment_success
   ```

**Примітка:** Для бота, що працює через inline кнопки, користувач не завжди переходить на веб-сторінку, тому це поле може бути порожнім.

### Неуспішний URL (Failed URL / Error URL)

URL, на який користувач буде перенаправлений після **неуспішної оплати** або **скасування**.

**Варіанти:**

1. **Стандартна сторінка AIFO (залишити порожнім):**
   ```
   (порожнє)
   ```

2. **Ваша сторінка помилки:**
   ```
   https://ваш-домен.com/pay/failed
   ```

3. **Посилання на Telegram бота:**
   ```
   https://t.me/ваш_бот
   ```

4. **Посилання з параметрами:**
   ```
   https://t.me/ваш_бот?start=payment_failed
   ```

## Крок 4: Отримання параметрів для config.py

Після створення магазину вам знадобляться:

1. **Shop ID (kassa_id):**
   - Знаходиться в налаштуваннях магазину
   - Вкажіть в `AIFO_SHOP_ID` в `config.py`

2. **Secret Key (kassa_secretkey):**
   - Секретний ключ магазину
   - Використовується для створення підписів
   - Вкажіть в `AIFO_SECRET_KEY` в `config.py`
   - **НЕ ПУБЛІКУЙТЕ** цей ключ!

3. **API URL:**
   - URL вашого AIFO API
   - Зазвичай: `https://ваш-домен.com/api/v1`
   - Вкажіть в `AIFO_API_URL` в `config.py`

## Крок 5: Приклад налаштування config.py

```python
# AIFO API конфігурація
AIFO_API_URL = 'https://aifo.pro/api/v1'  # Замініть на ваш домен
AIFO_SHOP_ID = 123  # ID магазину з AIFO панелі
AIFO_SECRET_KEY = 'abc123def456...'  # Секретний ключ з AIFO панелі
```

## Діаграма роботи платежу

```
1. Користувач -> Бот: Натискає "Поповнити баланс"
2. Бот -> AIFO API: Створює платіж (invoices/create)
3. AIFO API -> Бот: Повертає payment_url
4. Бот -> Користувач: Показує кнопку "Перейти до оплати"
5. Користувач -> Браузер: Оплачує платіж
6. Користувач -> Бот: Натискає "Перевірити оплату"
7. Бот -> AIFO API: Перевіряє статус (telegram/check)
8. AIFO API -> Бот: Повертає статус "paid"
9. Бот -> AIFO API: Відправляє webhook (telegram/webhook)
10. AIFO API -> Бот: Підтверджує зараховання
11. Бот -> Користувач: Повідомляє про поповнення балансу
```

## Важливі примітки

1. **URL сповіщення може бути порожнім** для Telegram бота, оскільки бот використовує API метод перевірки та відправки webhook

2. **Успішний/Неуспішний URL** використовуються тільки для платежних посилань, які відкриваються в браузері. Для inline кнопок вони не критичні

3. **Тип мерчанта** має бути `telegram` або `api` для правильної роботи

4. **Режим підпису** має відповідати тому, що використовується в коді (SHA256)

5. **Секретний ключ** має бути надійно захищений - ніколи не публікуйте його!

## Перевірка налаштувань

Після налаштування перевірте:

1. ✅ Магазин активовано (Status = 1)
2. ✅ Тип мерчанта = `telegram` або `api`
3. ✅ Secret Key правильно вказаний в config.py
4. ✅ Shop ID правильно вказаний в config.py
5. ✅ API URL доступний
6. ✅ Бот може створити платіж
7. ✅ Бот може перевірити статус платежу
8. ✅ Бот може відправити webhook

## Тестування

1. Запустіть бота
2. Спробуйте створити тестовий платіж
3. Перевірте логи бота
4. Перевірте, що платіж створюється в AIFO
5. Перевірте, що статус перевіряється правильно
6. Перевірте, що баланс поповнюється після оплати

## Усунення проблем

### Помилка "Мерчант не знайдено"

- Перевірте, що `AIFO_SHOP_ID` правильний
- Перевірте, що магазин активовано в AIFO

### Помилка "Невірна підпис"

- Перевірте, що `AIFO_SECRET_KEY` правильний
- Перевірте, що режим підпису в AIFO відповідає коду (SHA256)
- Перевірте, що формула підпису правильна: `shop_id:amount:secret_key:invoice_id`

### Помилка "Платіж не знайдено"

- Перевірте, що `invoice_id` правильний
- Перевірте, що платіж було створено через API

### Webhook не відправляється

- Перевірте, що API URL правильний
- Перевірте доступність API
- Перевірте логи бота на помилки

## Безпека

1. **Ніколи не публікуйте Secret Key**
2. Використовуйте HTTPS для API
3. Регулярно змінюйте Secret Key
4. Використовуйте сильні паролі для панелі AIFO
5. Включіть двофакторну аутентифікацію (якщо доступна)

## Додаткова інформація

Для детальнішої інформації про API див. документацію AIFO або файл `app/views/docs/telegram.php`.
