# Запуск Telegram бота

## Швидкий старт

### Windows

```bash
cd "modules\telegram bot"
python bot.py
```

### Linux/macOS

```bash
cd "modules/telegram bot"
python3 bot.py
```

## Запуск у фоновому режимі

### Використання screen

```bash
screen -S telegram-bot
cd "modules/telegram bot"
python3 bot.py
Ctrl+A, потім D для від'єднання
screen -r telegram-bot для повернення
```

### Використання tmux

```bash
tmux new -s telegram-bot
cd "modules/telegram bot"
python3 bot.py
Ctrl+B, потім D для від'єднання
tmux attach -t telegram-bot для повернення
```

## Запуск як systemd сервіс (Linux)

1. Створіть файл сервісу:

```bash
sudo nano /etc/systemd/system/telegram-bot.service
```

2. Додайте вміст:

```ini
[Unit]
Description=Telegram Bot for Digital Goods Sales
After=network.target

[Service]
Type=simple
User=ваш_користувач
WorkingDirectory=/повний/шлях/до/modules/telegram bot
ExecStart=/usr/bin/python3 /повний/шлях/до/modules/telegram bot/bot.py
Restart=always
RestartSec=10

[Install]
WantedBy=multi-user.target
```

3. Активуйте та запустіть:

```bash
sudo systemctl daemon-reload
sudo systemctl enable telegram-bot
sudo systemctl start telegram-bot
sudo systemctl status telegram-bot
```

## Зупинка бота

**Якщо запущено вручну:** `Ctrl+C`

**Якщо запущено як сервіс:**
```bash
sudo systemctl stop telegram-bot
```

## Перезапуск бота

**Якщо запущено як сервіс:**
```bash
sudo systemctl restart telegram-bot
```

## Перевірка логів

**Якщо запущено вручну:** Логи відображаються в консолі

**Якщо запущено як сервіс:**
```bash
sudo journalctl -u telegram-bot -f
```

**Логи у файлі:**
```bash
tail -f "modules/telegram bot/bot.log"
```
